import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Random;

import static pkg.Main.main;

import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class AutomatedTelnetClient {

	public static void main(String[] args) {
		try {
			final int LOCATIONS_COUNT = 0;
			final int MIN_WAIT = 100;
			final int MAX_WAIT = 1000;
			final double MIN_LATITUDE_DELTA = -0.01;
			final double MIN_LONGITUDE_DELTA = -0.01;
			final double MAX_LATITUDE_DELTA = 0.01;
			final double MAX_LONGITUDE_DELTA = 0.01;
			
			TarArchiveInputStream tais = new TarArchiveInputStream(new FileInputStream("D:\\test.tar"));
			TarArchiveEntry tae = tais.getNextTarEntry();
			long size = tae.getSize();
			byte[] buffer = new byte[(int) size];
			tais.read(buffer, 0, (int) size);
			System.out.println(Arrays.toString(buffer));
			
			GeoTelnetClient telnet = new GeoTelnetClient("localhost", 5554);
			
			//telnet.geoFix(0, 0);
			double longitude = -73.9865;
			double latitude = 40.7486;
			Random rand = new Random();
			for (int i = 0; i < LOCATIONS_COUNT; i++) {
				telnet.geoFix(longitude, latitude);
				double d_longitude = MIN_LONGITUDE_DELTA + (MAX_LONGITUDE_DELTA - MIN_LONGITUDE_DELTA) * rand.nextDouble();;
				double d_latitude = MIN_LATITUDE_DELTA + (MAX_LATITUDE_DELTA - MIN_LATITUDE_DELTA) * rand.nextDouble();;
				int sleep = rand.nextInt(MAX_WAIT - MIN_WAIT + 1) + MIN_WAIT;
				longitude += d_longitude;
				latitude += d_latitude;
				Thread.sleep(sleep);
			}
			telnet.disconnect();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}